/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageTabIngredientComponentCommon<T, M>
implements ITerminalStorageTabCommon,
IVariableFacade.IValidator {
    private final ContainerTerminalStorageBase containerTerminalStorage;
    private final ResourceLocation name;
    protected final IngredientComponent<T, M> ingredientComponent;
    private final int errorsValueId;
    private SimpleInventory inventory = null;
    private boolean dirtyInv;
    private final List<InventoryVariableEvaluator<ValueTypeOperator.ValueOperator>> variableEvaluators = Lists.newArrayList();
    private final List<IVariable<ValueTypeOperator.ValueOperator>> variables = Lists.newArrayList();
    private int variableSlotNumberStart;
    private int variableSlotNumberEnd;

    public TerminalStorageTabIngredientComponentCommon(ContainerTerminalStorageBase containerTerminalStorage, ResourceLocation name, IngredientComponent<T, M> ingredientComponent) {
        this.containerTerminalStorage = containerTerminalStorage;
        this.name = name;
        this.ingredientComponent = ingredientComponent;
        this.errorsValueId = containerTerminalStorage.getNextValueId();
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public List<Slot> loadSlots(AbstractContainerMenu container, int startIndex, Player player, Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventoryOptional) {
        ITerminalStorageTabCommon.IVariableInventory variableInventory = variableInventoryOptional.get();
        ArrayList slots = Lists.newArrayList();
        this.variableSlotNumberStart = startIndex;
        this.inventory = new SimpleInventory(3, 1);
        variableInventory.loadNamedInventory(this.getName().toString(), (Container)this.inventory);
        this.variableEvaluators.clear();
        int i = 0;
        while (i < this.inventory.m_6643_()) {
            final int slot = i++;
            this.variableEvaluators.add(new InventoryVariableEvaluator<ValueTypeOperator.ValueOperator>((Container)this.inventory, slot, (IValueType)ValueTypes.OPERATOR){

                public void onErrorsChanged() {
                    super.onErrorsChanged();
                    TerminalStorageTabIngredientComponentCommon.this.setLocalErrors(slot, this.getErrors());
                }
            });
        }
        this.variableSlotNumberEnd = startIndex + this.inventory.m_6643_();
        this.inventory.addDirtyMarkListener(() -> {
            this.dirtyInv = true;
        });
        slots.add(new SlotVariable((Container)this.inventory, 0, 201, 136));
        slots.add(new SlotVariable((Container)this.inventory, 1, 201, 154));
        slots.add(new SlotVariable((Container)this.inventory, 2, 201, 172));
        this.dirtyInv = true;
        return slots;
    }

    public int getVariableSlotNumberStart() {
        return this.variableSlotNumberStart;
    }

    public int getVariableSlotNumberEnd() {
        return this.variableSlotNumberEnd;
    }

    @Override
    public void onUpdate(AbstractContainerMenu container, Player player, Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventory) {
        if (this.dirtyInv && !player.f_19853_.f_46443_) {
            this.dirtyInv = false;
            ContainerTerminalStorageBase containerTerminalStorage = (ContainerTerminalStorageBase)container;
            variableInventory.get().saveNamedInventory(this.getName().toString(), (Container)this.inventory);
            INetwork network = containerTerminalStorage.getNetwork().get();
            this.clearGlobalErrors();
            this.variables.clear();
            if (network == null) {
                this.addError((MutableComponent)new TranslatableComponent("general.integrateddynamics.error.no_network"));
            } else {
                for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                    InventoryVariableEvaluator<ValueTypeOperator.ValueOperator> evaluator = this.variableEvaluators.get(i);
                    evaluator.refreshVariable(network, false);
                    IVariable variable = evaluator.getVariable(network);
                    if (variable != null) {
                        variable.addInvalidationListener(() -> this.inventory.m_6596_());
                        this.variables.add((IVariable<ValueTypeOperator.ValueOperator>)variable);
                    }
                    containerTerminalStorage.onVariableContentsUpdated(network, variable);
                }
            }
            TerminalStorageTabIngredientComponentServer tabServer = (TerminalStorageTabIngredientComponentServer)containerTerminalStorage.getTabServer(this.getName().toString());
            tabServer.updateFilter(this.variables, this);
            tabServer.reApplyFilter();
        }
    }

    public void addError(MutableComponent error) {
        List<Component> errors = this.getGlobalErrors();
        errors.add((Component)error);
        CompoundTag tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        tag = tag == null ? new CompoundTag() : tag.m_6426_();
        NBTClassType.writeNbt(List.class, (String)(this.getName().toString() + ":globalErrors"), errors, (CompoundTag)tag);
        this.containerTerminalStorage.setValue(this.errorsValueId, tag);
    }

    public List<Component> getGlobalErrors() {
        CompoundTag tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        if (tag == null) {
            return Lists.newArrayList();
        }
        return (List)NBTClassType.readNbt(List.class, (String)(this.getName().toString() + ":globalErrors"), (CompoundTag)tag);
    }

    public void clearGlobalErrors() {
        CompoundTag tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        tag = tag == null ? new CompoundTag() : tag.m_6426_();
        NBTClassType.writeNbt(List.class, (String)(this.getName().toString() + ":globalErrors"), (Object)Lists.newArrayList(), (CompoundTag)tag);
        this.containerTerminalStorage.setValue(this.errorsValueId, tag);
    }

    public void setLocalErrors(int slot, List<MutableComponent> errors) {
        CompoundTag tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        tag = tag == null ? new CompoundTag() : tag.m_6426_();
        NBTClassType.writeNbt(List.class, (String)(this.getName().toString() + ":localErrors" + slot), errors, (CompoundTag)tag);
        this.containerTerminalStorage.setValue(this.errorsValueId, tag);
    }

    public List<Component> getLocalErrors(int slot) {
        CompoundTag tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        if (tag == null) {
            return Lists.newArrayList();
        }
        return (List)NBTClassType.readNbt(List.class, (String)(this.getName().toString() + ":localErrors" + slot), (CompoundTag)tag);
    }

    public boolean hasErrors() {
        return !this.getGlobalErrors().isEmpty();
    }
}

